import math


def main():
    i = int(input())
    num_steps = get_num_steps(i)
    print(num_steps)

def solve_b(i):
    path = gen_path(i)
    num_paths = num_permutations(path)
    if path != path[::-1]:
        num_paths *= 2

    if i % 4 == 2 and i > 6:
        other = [path[0] - 1, path[1] + 2, path[2] - 2, path[3] + 1]
        other_num_paths = num_permutations(other) * 2
        num_paths += other_num_paths

    return num_paths

def get_num_steps(i):
    if i == 0:
        return 0
    elif i == 1:
        return 3
    else:
        return (i + i % 4) // 2

"""
The indices represent the following moves and negative values represent the opposite moves.
  0
   1
♘
   2
  3
"""
# [-1, 2, -2, 1]
def gen_path(i):
    if i == 0:
        return [0,0,0,0]
    elif i == 1:
        return [1,-1,1,0]
    elif i == 2:
        return [1,0,0,1]
    elif i == 3:
        return [-1,2,0,0]
    elif i == 4:
        return [0,1,1,0]
    elif i == 5:
        return [0,2,0,1]
    else:
        end_length = i % 4
        if end_length <= 1:
            end_length += 4
        end = gen_path(end_length)
        num_steps_of_four = (i - end_length) // 4
        return [end[0], end[1]+num_steps_of_four, end[2]+num_steps_of_four, end[3]]

def num_permutations(path):
    abs_path = [abs(i) for i in path]
    return math.factorial(sum(abs_path)) // math.prod([math.factorial(i) for i in abs_path])

if __name__ == "__main__":
    main()